// add.js <full path> [playlist name]
//
// adds a file to a playlist. creates the playlist if it doesn't exist.
// -samy
//

var iTunesApp = WScript.CreateObject("iTunes.Application");
var mainLibrary = iTunesApp.LibraryPlaylist;
var mainLibrarySource = iTunesApp.LibrarySource;

// get all playlists
var playlists = mainLibrarySource.Playlists;

var playlistStr = "Library"; // default to library if no library is supplied
var file;
var play = 0;

if (WScript.Arguments.length == 3)
{
	play = 1;
	file = WScript.Arguments(0);
	playlistStr = WScript.Arguments(1);
}
else if (WScript.Arguments.length == 2)
{
	file = WScript.Arguments(0);
	playlistStr = WScript.Arguments(1);
}
else if (WScript.Arguments.length == 1)
{
	file =  WScript.Arguments(0);
}
else
{
	WScript.Echo("Please supply the file name as an argument");
}


// loop through playlists
var added = 0;
for (i = 1; i <= playlists.count; i++)
{
	var playlist = playlists.Item(i);
	if (playlist.name == playlistStr)
	{
		added = 1;
	        playlist.AddFile(file);
	}

}

// the playlist doesn't exist, lets create it
if (added == 0)
{
	var playlist = iTunesApp.CreatePlaylist(playlistStr);
	playlist.addFile(file);
}	
