//#include <windows.h>
#include <limits.h>
#include <stdio.h>
#include "criticalsection.h"
#include "semaphore.h"

//************************************************************
//ThreadSafeQueue
//************************************************************

struct TSElement {
  TSElement * Next;
  void * Data;
};

// This is a standard queue that is thread safe (using critical sections)

class ThreadSafeQueue
{
  public:
    ThreadSafeQueue(LONG MaxQueueSize=LONG_MAX-1);
    ~ThreadSafeQueue();
    BOOL Push(void * Data);
    void * Pop(int Timeout=0,HANDLE hEvent=NULL);
    LONG Count();
  private:
    CriticalSection QueueLock;
    TSElement * First;
    TSElement * Last;
    Semaphore *ElementCounter;
};
